/*-
 * host.c --
 *	Program to test the host request function of customs.
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char rcsid[] =
"$Id: host.c,v 1.6 1993/12/24 06:31:30 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include <stdio.h>
#include <string.h>
#include <sys/time.h>

#include "customs.h"

main(argc, argv)
    int argc;
    char **argv;
{
    ExportPermit  permit;
    struct timeval start,
		   end;
    char 	*progname = argv[0];
    int		flags = 0;
    Lst 	attributes = NILLST;
    Boolean	quiet = FALSE;
    int		max = 10;
    int		i;
    
    for (argv++, argc--; argc > 0; argv++, argc--) {
	if (strcmp(argv[0], "-quiet") == 0) {
	    quiet = TRUE;
	} else if (strcmp(argv[0], "-same") == 0) {
	    flags |= EXPORT_SAME;
	} else if (strcmp(argv[0], "-uselocal") == 0) {
	    flags |= EXPORT_USELOCAL;
	} else if (strcmp(argv[0], "-force") == 0) {
	    flags |= EXPORT_FORCE;
	} else if (strcmp(argv[0], "-test") == 0) {
	    flags |= EXPORT_TEST;
	} else if (strcmp (argv[0], "-attr") == 0) {
	    if (argc == 1) {
		fprintf(stderr, "%s: missing attribute value\n", progname);
		exit (2);
	    } else {
		if (attributes == NILLST) {
		    attributes = Lst_Init (FALSE);
		}
		(void)Lst_AtEnd (attributes, (ClientData)argv[1]);
		argv++; argc--;
	    }
	} else if (*argv[0] == '-') {
	    fprintf(stderr, "Usage: %s [-same] [-uselocal] [-test] [-force] [-attr <string> ...] [<howmany>]\n",
			    progname);
	    exit (2);
	} else {
	    break;
	}
    }

    if (argc > 0) {
	max = atoi(argv[0]);
    }

    Customs_Init();
    (void)setuid(getuid());	/* in case we're using reserved ports */

    (void)gettimeofday(&start, (struct timezone *)0);
    for (i = 0; i < max; i++) {
	if ((attributes == NILLST ?
		Customs_Host(flags, &permit) :
		Customs_HostAttr(flags, attributes, &permit)) != RPC_SUCCESS) {
	    Customs_PError(progname);
	} else if (!quiet) {
	    printf ("response: id %d, host %s\n", permit.id,
		    InetNtoA(permit.addr));
	}
    }
    gettimeofday(&end, (struct timezone *)0);
    end.tv_usec -= start.tv_usec;
    if (end.tv_usec < 0) {
	end.tv_usec += 1000000;
	end.tv_sec -= 1;
    }
    end.tv_sec -= start.tv_sec;
    printf ("elapsed time: %d.%06d\n%.6f seconds per rpc\n",
	    end.tv_sec, end.tv_usec,
	    ((end.tv_sec+end.tv_usec/1e6)/max));
	    
}
	    
