/*****************************************************************

Copyright (c) 2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __container_panel_h__
#define __container_panel_h__

#include <netwm_def.h>
#include <qframe.h>
#include <qptrlist.h>

#include "global.h"
#include "unhidetrigger.h"

class QPopupMenu;
class QTimer;
class QBoxLayout;
class QVBox;
class KArrowButton;
class KConfig;
class KWinModule;
class PopupWidgetFilter;

class PanelSettings
{
public:
    enum HideMode { Manual, Automatic, Background };
    PanelSettings();
    void readConfig( KConfig* c );
    void writeConfig( KConfig* c );

    // Configuration settings
    Position  _position;
    Alignment _alignment;
    int       _xineramaScreen;
    int       _HBwidth;
    bool      _showLeftHB;
    bool      _showRightHB;
    HideMode  _hideMode;
    bool      _autoHideSwitch;
    int       _autoHideDelay;
    bool      _hideAnim;
    int       _hideAnimSpeed;
    UnhideTrigger::Trigger _unhideLocation;
    Size       _size;
    int       _customSize;
    bool      _showToolTips; // ### unused
    int       _sizePercentage;
    bool      _expandSize;
};

class PanelContainer : public QFrame
{
    Q_OBJECT

public:
    PanelContainer(QWidget *parent, const char *name);
    virtual ~PanelContainer();

    Position position() const { return _settings._position; }
    void setPosition(Position p) { arrange( p, alignment(), xineramaScreen() ); }

    int xineramaScreen() const;
    void setXineramaScreen(int screen) { arrange(position(),alignment(), screen); }

    void setSize(Size size, int customSize = 0);
    Size size() const;
    int customSize() const;

    Alignment alignment() const { return _settings._alignment; }
    void setAlignment(Alignment a) { arrange( position(), a, xineramaScreen() ); }

    enum UserHidden{ Unhidden, LeftTop, RightBottom };
    QRect initialGeometry( Position p, Alignment a, int XineramaScreen, bool autoHidden = false, UserHidden userHidden = Unhidden );

    virtual QSize sizeHint( Position p, const QSize &maxSize );
    bool eventFilter( QObject *, QEvent * );

    virtual void readConfig() {};
    virtual void writeConfig() {};
    void readConfig(KConfig* config);
    void writeConfig(KConfig* config);

    virtual QString panelId() const = 0;

signals:
    void positionChange( Position pos );
    void alignmentChange( Alignment a );
    void xineramaScreenChange ( int XineramaScreen );
    void sizeChange( Size size, int customSize );

protected:
    virtual void closeEvent( QCloseEvent* e );

    void arrange( Position p, Alignment a, int XineramaScreen );
    void setMainWidget( QWidget* widget );
    virtual PanelSettings defaultSettings() const;
    bool autoHidden() const { return _autoHidden; };
    UserHidden userHidden() const { return _userHidden; };
    Orientation orientation() const;
    virtual void resetLayout();
    virtual bool vetoAutoHide() const { return false; }
    QRect workArea(int XineramaScreen);

    static KWinModule* kWinModule;

protected slots:
    virtual void showPanelMenu( const QPoint& /* globalPos */ ) {};
    void moveMe();
    void updateLayout();
    void enableZoomedIcons();

private slots:
    void unhideTriggered( UnhideTrigger::Trigger t, int XineramaScreen );
    void autoHideTimeout();
    void hideLeft();
    void hideRight();
    void autoHide(bool hide);
    void animatedHide(bool left);
    void updateWindowManager();
    void currentDesktopChanged(int);
    void strutChanged();
    void blockUserInput( bool block );
    void maybeStartAutoHideTimer();
    void stopAutoHideTimer();

private:
    QSize initialSize( Position p, int XineramaScreen );
    QPoint initialLocation( Position p, Alignment a, int XineramaScreen, 
                            const QSize &s, bool autohidden = false, 
                            UserHidden userHidden = Unhidden );

    PanelSettings    _settings;

    // State variables
    bool             _autoHidden;
    UserHidden       _userHidden;
    bool             _block_user_input;
    QPoint           _last_lmb_press;
    bool             _is_lmb_down;
    bool             _in_autohide;

    // Misc objects
    QTimer           *_autohideTimer;
    NETStrut         _strut;
    PopupWidgetFilter *_popupWidgetFilter;

    // Widgets
    KArrowButton     *_ltHB; // Left Hide Button
    KArrowButton     *_rbHB; // Right Hide Button
    QBoxLayout       *_layout;

};

class PopupWidgetFilter : public QObject
{
    Q_OBJECT

public:
    PopupWidgetFilter( QObject *parent );
    ~PopupWidgetFilter() {};
    bool eventFilter( QObject *obj, QEvent* e );
signals:
    void popupWidgetHiding();
};

#endif
