/***************************************************************************
                            KLineEdit.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KLINEEDIT_H
#define KLINEEDIT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KCompletionBase.h>
#include <qtobjc/QLineEdit.h>

/**

 An enhanced QLineEdit widget for inputting text.

 This widget inherits from @ref QLineEdit and implements the following
 additional functionalities: q completion object that provides both
 automatic and manual text completion as well as multiple match iteration
 features, configurable key-bindings to activate these features and a
 popup-menu item that can be used to allow the user to set text completion
 modes on the fly based on their preference.

 To support these new features KLineEdit also emits a few more
 additional signals.  These are: @ref completion( const QString& ),
 textRotation( KeyBindingType ), and @ref returnPressed( const QString& ).
 The completion signal can be connected to a slot that will assist the
 user in filling out the remaining text.  The text rotation signal is
 intended to be used to iterate through the list of all possible matches
 whenever there is more than one match for the entered text.  The
 @p returnPressed( const QString& ) signals are the same as QLineEdit's
 except it provides the current text in the widget as its argument whenever
 appropriate.

 This widget by default creates a completion object when you invoke
 the @ref completionObject( bool ) member function for the first time or
 use @ref setCompletionObject( KCompletion*, bool ) to assign your own
 completion object.  Additionally, to make this widget more functional,
 KLineEdit will by default handle the text rotation and completion
 events internally when a completion object is created through either one
 of the methods mentioned above.  If you do not need this functionality,
 simply use @ref -[KCompletionBase setHandleSignals]( bool ) or set the
 boolean parameter in the above functions to FALSE.

 The default key-bindings for completion and rotation is determined
 from the global settings in @ref KStdAccel.  These values, however,
 can be overriden locally by invoking @ref -[KCompletionBase setKeyBinding].
 The values can easily be reverted back to the default setting, by simply
 calling @ref -useGlobalSettings. An alternate method would be to default
 individual key-bindings by usning @ref -setKeyBinding with the default
 second argument.

 NOTE that if the @p EchoMode for this widget is set to something other
 than @p -[QLineEdit Normal], the completion mode will always be defaulted
 to @ref -[KGlobalSettings CompletionNone].  This is done purposefully to guard
 against protected entries such as passwords being cached in @ref KCompletion's
 list. Hence, if the @p EchoMode is not @ref -[QLineEdit Normal], the completion
 mode is automatically disabled.

 To enable the basic completion feature :

 <pre>
 KLineEdit *edit = new KLineEdit( this, "mywidget" );
 KCompletion *comp = -[edit completionObject];
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 To use a customized completion objects or your
 own completion object :

 <pre>
 KLineEdit *edit = new KLineEdit( this,"mywidget" );
 KURLCompletion *comp = new -KURLCompletion;
 -[edit setCompletionObject]( comp );
 // Connect to the return pressed signal - optional
 connect(edit,SIGNAL(returnPressed(const QString&)),comp,SLOT(addItem(const QString&));
 </pre>

 Note that you have to either delete the allocated completion object
 when you don't need it anymore, or call
 setAutoDeleteCompletionObject( true );

 <pre>
 // Tell the widget not to handle completion and
 // iteration internally.
 -[edit setHandleSignals]( false );
 // Set your own completion key for manual completions.
 -[edit setKeyBinding]( -[KCompletionBase TextCompletion], -[Qt End]);
 // Hide the context (popup) menu
 -[edit setContextMenuEnabled]( false );
 // Temporarly disable signal emitions
 // (both completion & iteration signals)
 -[edit disableSignals];
 // Default the key-bindings to system settings.
 -[edit useGlobalKeyBindings];
 </pre>

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An enhanced single line input widget.

*/

@class KCompletion;
@class KCompletionBox;
@class KURL;

@interface KLineEdit : QLineEdit

/** 
 Constructs a KLineEdit object with a default text, a parent,
 and a name.

*/
- initWithText: (NSString *)string parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)string parent: (QWidget *)parent ;

/** 
 Constructs a KLineEdit object with a parent and a name.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
  Destructor.
     
*/
- (void) dealloc;

/** 
 Sets @p url into the lineedit. It uses @ref -[KURL prettyURL] so
 that the url is properly decoded for displaying.
     
*/
- setURL: (KURL*)url;

/** 
 Puts the text cursor at the end of the string.

 This method is deprecated.  Use @ref -[QLineEdit end]
 instead.

 @ref -[QLineEdit end]
     
*/
- cursorAtEnd;

/** 
 Re-implemented from @ref KCompletionBase for internal reasons.

 This function is re-implemented in order to make sure that
 the EchoMode is acceptable before we set the completion mode.

 See @ref -[KCompletionBase setCompletionMode]
*/
- setCompletionMode: (int)mode;

/** 
 Enables/disables the popup (context) menu.

 Note that when this function is invoked with its argument
 set to @p true, then both the context menu and the completion
 menu item are enabled.  If you do not want to the completion
 item to be visible simply invoke @ref -hideModechanger right
 after calling this method.  Also by default, the context
 menu is automatically created if this widget is editable. Thus
 you need to call this function with the argument set to false
 if you do not want this behaviour.

*/
- setContextMenuEnabled: (BOOL)showMenu;

/** 
 Returns @p true when the context menu is enabled.
     
*/
- (BOOL) isContextMenuEnabled;

/** 
 Enables/Disables handling of URL drops. If enabled and the user
 drops an URL, the decoded URL will be inserted. Otherwise the default
 behaviour of QLineEdit is used, which inserts the encoded URL.

*/
- setURLDropsEnabled: (BOOL)enable;

/** 
 Returns @p true when decoded URL drops are enabled
     
*/
- (BOOL) isURLDropsEnabled;

/** 
 By default, KLineEdit recognizes @p Key_Return and @p Key_Enter and emits
 the @ref -returnPressed signals, but it also lets the event pass,
 for example causing a dialog's default-button to be called.

 Call this method with @p trap = @p true to make @p KLineEdit stop these
 events. The signals will still be emitted of course.

*/
- setTrapReturnKey: (BOOL)trap;

/** 

*/
- (BOOL) trapReturnKey;

/** 

*/
- (KCompletionBox*) completionBox: (BOOL)create;
- (KCompletionBox*) completionBox;

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
- setCompletionObject: (KCompletion*)arg1 hsig: (BOOL)hsig;
- setCompletionObject: (KCompletion*)arg1 ;

/** 
 Iterates through all possible matches of the completed text or
 the history list.

 This function simply iterates over all possible matches in case
 multimple matches are found as a result of a text completion request.
 It will have no effect if only a single match is found.

*/
- rotateText: (int)arg1;

/** 
 See @ref -[KCompletionBase setCompletedText].
     
*/
- setCompletedText: (NSString *)arg1;

/** 
 Sets @p items into the completion-box if @ref -completionMode is
 CompletionPopup. The popup will be shown immediately.
     
*/
- setCompletedItems: (NSArray *)items;

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QLineEdit createPopupMenu].
    
*/
- (QPopupMenu*) createPopupMenu;
- setCompletedText: (NSString *)arg1 bool: (BOOL)arg2;

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
- create: (unsigned int)arg1 initializeWindow: (BOOL)initializeWindow destroyOldWindow: (BOOL)destroyOldWindow;
- create;

/** 
 Completes the remaining text with a matching one from
 a given list.
    
*/
- makeCompletion: (NSString *)arg1;

/** 

     
*/
- slotAboutToShow;

/** 

     
*/
- slotCancelled;
@end

@class KCompletion; 
@class KCompletionBox; 
@class KURL; 

@interface KLineEdit (KCompletionBaseImplementation) <KCompletionBaseInterface>
@end

/** Override these methods in subclasses of KLineEdit to customise event handling behaviour */
@protocol KLineEditEventHandling

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QLineEdit keyPressEvent].
    
*/
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QLineEdit mousePressEvent].
    
*/
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;

/** 
 Re-implemented for internal reasons.  API not affected.

 See @ref -[QWidget mouseDoubleClickEvent].
    
*/
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) e;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;

/** 
 Re-implemented to handle URI drops.

 See @ref -[QLineEdit dropEvent].
    
*/
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
