//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMPATTERN_H
#define PMPATTERN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmobject.h"
#include "pmvector.h"

#include <qvaluelist.h>
#include <qvaluestack.h>

/**
 * Class for povray patterns.
 */ 

class PMPattern : public PMObject
{
   typedef PMObject Base;
public:
   /** The type of the pattern */
   enum PMPatternType { PatternAgate, PatternAverage, PatternBoxed,
                        PatternBozo, PatternBumps, PatternCrackle,
                        PatternCylindrical, PatternDensity,
                        PatternDents, PatternGradient, PatternGranite,
                        PatternLeopard, PatternMandel, PatternMarble,
                        PatternOnion, PatternPlanar, PatternQuilted,
                        PatternRadial, PatternRipples, PatternSpherical,
                        PatternSpiral1, PatternSpiral2, PatternSpotted,
                        PatternWaves, PatternWood, PatternWrinkles };
   /** Creates a PMPattern */
   PMPattern( );
   /** deletes the PMPattern */
   virtual ~PMPattern( );

   /** */
   virtual PMObject* newObject( ) const { return new PMPattern( ); }
   /** */
   virtual QString className( ) const { return QString( "pattern" ); }
   /** */
   virtual QString description( ) const;
   /** */
   virtual PMObjectType type( ) const { return PMTPattern; }
   /** */
   virtual bool isA( PMObjectType t ) const;
   /** */
   virtual QString pixmap( ) const { return QString( "pmpattern" ); }

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );
   
   /** Returns a new @ref PMPatternEdit */
   virtual PMDialogEditBase* editWidget( QWidget* parent ) const;

   /** Gets the pattern type */
   PMPatternType patternType( ) const { return m_patternType; }
   /** Gets the agate Turbulence*/
   double agateTurbulence( ) const { return m_agateTurbulence; }
   /** Gets the number of arms in spiral types 1 and 2 */
   int spiralNumberArms( ) const { return m_spiralNumberArms; }
   /** Gets the Maximum Iterations for mandelbrot sets  */
   int maxIterations( ) const { return m_maxIterations; }
   /** Gets the gradint vector */
   PMVector gradient( ) const { return m_gradient; }
   /** Gets control0 for Quilt */
   double quiltControl0( ) const { return m_quiltControl0; }
   /** Gets control1 for Quilt */
   double quiltControl1( ) const { return m_quiltControl1; }
   /** Gets the desity file name */
   QString densityFile( ) const { return m_densityFile; }
   /** */
   int densityInterpolate( ) const { return m_densityInterpolate; }
   /** */
   PMVector valueVector( ) const { return m_valueVector; }
   /** */
   int octaves( ) const { return m_octaves; }
   /** */
   double omega( ) const { return m_omega; }
   /** */
   double lambda( ) const { return m_lambda; }
   /** */
   bool isTurbulenceEnabled( ) const { return m_enableTurbulence; }
   /** Returns depth (only has meaning inside a normal) */
   double depth( ) const { return m_depth; }

   /** Sets the pattern type */
   void setPatternType( PMPatternType l );
   /** */
   void setAgateTurbulence( double c );
   /** */
   void setSpiralNumberArms( int c );
   /** */
   void setMaxIterations( int c );
   /** */
   void setQuiltControl0( double c );
   /** */
   void setQuiltControl1( double c );
   /** */
   void setGradient( const PMVector& v );
   /** Sets the Density File Name */
   void setDensityFile( const QString& v );
   /** */
   void setDensityInterpolate( int c );
   /** */
   void setValueVector( const PMVector& v );
   /** */
   void setOctaves( int c );
   /** */
   void setOmega( double c );
   /** */
   void setLambda( double c );
   /** */
   void enableTurbulence( bool c );
   /** Sets the depth value (only inside normals) */
   void setDepth( double c );

   /** */
   virtual void restoreMemento( PMMemento* s );
private:
   /** IDs for @ref PMMementoData */
   enum PMPatternMementoID { PMPatternTypeID, PMAgateTurbulenceID, 
                             PMSpiralNumberArmsID, PMMaxIterationsID, 
                             PMQuiltControl0ID, PMQuiltControl1ID,
                             PMDensityInterpolateID, PMGradientID, 
                             PMDensityFileID, PMEnableTurbulenceID, 
                             PMValueVectorID, PMOctavesID, PMOmegaID, 
                             PMLambdaID, PMDepthID };
   /** Pattern type */
   PMPatternType m_patternType;
   double m_agateTurbulence;
   int m_spiralNumberArms;
   int m_maxIterations;
   PMVector m_gradient;
   double m_quiltControl0;
   double m_quiltControl1;
   QString m_densityFile;
   int m_densityInterpolate;
   bool m_enableTurbulence;
   PMVector m_valueVector;
   int m_octaves;
   double m_omega;
   double m_lambda;
   double m_depth;
};

#endif
