/*
 * Copyright (C) 2002 Marco Wegner <mail@marcowegner.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#include "kfile_po.h"

#include <qstringlist.h>

#include "catalog.h"
#include <kgenericfactory.h>


typedef KGenericFactory<KPoPlugin> POFactory;
K_EXPORT_COMPONENT_FACTORY(kfile_po, POFactory("kfile_po"))

KPoPlugin::KPoPlugin(QObject *parent, const char *name,
                     const QStringList& args)
  : KFilePlugin(parent, name, args)
{
  KFileMimeTypeInfo* info = addMimeTypeInfo("application/x-gettext");

  KFileMimeTypeInfo::GroupInfo* group =
    addGroupInfo(info, "CatalogInfo", i18n("Catalog Information"));

  KFileMimeTypeInfo::ItemInfo* item;
  item = addItemInfo(group, "Total", i18n("Total Messages"), QVariant::Int);
  item = addItemInfo(group, "Fuzzy", i18n("Fuzzy Messages"), QVariant::Int);
  item = addItemInfo(group, "Untranslated", i18n("Untranslated Messages"), QVariant::Int);
  item = addItemInfo(group, "LastTranslator", i18n("Last Translator"), QVariant::String);
  item = addItemInfo(group, "LanguageTeam", i18n("Language Team"), QVariant::String);
  item = addItemInfo(group, "Revision", i18n("Revision"), QVariant::String);
}

bool KPoPlugin::readInfo(KFileMetaInfo& metaInfo, uint)
{
  PoInfo poInfo;
  QStringList wordList;
  Catalog::IOStatus status = Catalog::info(metaInfo.path(), poInfo,
					   wordList, false, false);
  if (status == Catalog::OK) {
    KFileMetaInfoGroup group = appendGroup(metaInfo, "CatalogInfo");

    appendItem(group, "Total", poInfo.total);
    appendItem(group, "Fuzzy", poInfo.fuzzy);
    appendItem(group, "Untranslated", poInfo.untranslated);
    appendItem(group, "LastTranslator", poInfo.lastTranslator);
    appendItem(group, "LanguageTeam", poInfo.languageTeam);
    appendItem(group, "Revision", poInfo.revision);

    return true;
  }
  return false;
}

#include "kfile_po.moc"
