/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef DICTCHOOSER_H
#define DICTCHOOSER_H

#include <qptrlist.h>
#include <qstringlist.h>
#include <qwidget.h>
#include <kbabeldictbox.h>

class KListBox;

class QPushButton;
class QListBoxItem;


class DictChooser : public QWidget
{
    Q_OBJECT

public:
    DictChooser(QPtrList<ModuleInfo>& list, QStringList selected, 
            QWidget *parent , const char *name=0);

    QStringList selectedDicts();

    virtual bool eventFilter(QObject *, QEvent *);
    
private slots:
    void select();
    void unselect();
    void up();
    void down();

    void selectedMarked(int);
    void unselectedMarked(int);


private:
    QPtrList<ModuleInfo> dictList;

    KListBox *selectedBox;
    KListBox *unselectedBox;
    
    QPushButton *selectBtn;
    QPushButton *unselectBtn;
    QPushButton *upBtn;
    QPushButton *downBtn;
};

#endif // DICTCHOOSER_H
