/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */


#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include "kbabeldict.h"
#include "kbabeldictview.h"

#include <kdebug.h>

KBabelDict::KBabelDict()
          : KDialogBase(0,"kbabeldictmain",false,i18n("KBabelDict")
                         , Close|Help|User1|User2|User3|Ok, Ok, true
                         , i18n("About"), i18n("About Module")
                         , i18n("Hide Sett&ings"))
{
    connect(this, SIGNAL(closeClicked()),this,SLOT(saveConfig()));
    connect(this, SIGNAL(closeClicked()),this,SLOT(quit()));

    view = new KBabelDictView(this);
    connect(this, SIGNAL(user1Clicked()), view, SLOT(about()));
    connect(this, SIGNAL(user2Clicked()), view, SLOT(aboutModule()));
    connect(this, SIGNAL(user3Clicked()), this, SLOT(togglePref()));

    // HACK: hide default button, otherwise it would be Help button
    showButtonOK(false);

    setMainWidget(view);

    readConfig();
}

KBabelDict::~KBabelDict()
{
    delete(view);
}

void KBabelDict::saveConfig()
{
    KConfig *config=KGlobal::config();
    KConfigGroupSaver gs(config,"KBabelDict");
    config->writeEntry("Preferences",view->prefVisible());
}

void KBabelDict::readConfig()
{
    KConfig *config=KGlobal::config();
    KConfigGroupSaver gs(config,"KBabelDict");
    bool pref=config->readBoolEntry("Preferences",true);

    if(view->prefVisible() != pref)
    {
        togglePref();
    }
}

void KBabelDict::quit()
{
    kapp->quit();
}

void KBabelDict::togglePref()
{
    view->togglePref();

    if(view->prefVisible())
    {
        setButtonText(User3,i18n("Hide Sett&ings"));
    }
    else
    {
        setButtonText(User3,i18n("Show Sett&ings"));
    }
}


#include "kbabeldict.moc"
