//Auto-generated by kalyptus. DO NOT EDIT.
namespace Nepomuk {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class Resource resource.h Nepomuk/Resource
    ///  \brief Resource is the central object type in Nepomuk. It represents a piece of
    ///  information of any kind.
    ///  Resources are identified by their unique URI (which
    ///  correlates directly with the URI in the local NEPOMUK RDF storage.
    ///  Resource objects with the same URI share their data.
    ///  All methods in Resource are thread-safe.
    ///  See \ref hacking for details on how to use Resource.
    ///  \see ResourceManager
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///      </remarks>        <short>    \class Resource resource.</short>
    [SmokeClass("Nepomuk::Resource")]
    public class Resource : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Resource(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Resource), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Resource() {
            staticInterceptor = new SmokeInvocation(typeof(Resource), null);
        }
        // Nepomuk::Resource* Resource(Nepomuk::ResourceData* arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Creates an empty invalid Resource.
        ///  An invalid resource will become valid (i.e. get a new random URI) once setProperty
        ///  is called.
        ///          </remarks>        <short>    Creates an empty invalid Resource.</short>
        public Resource() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource", "Resource()", typeof(void));
        }
        public Resource(Nepomuk.Resource arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource#", "Resource(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), arg1);
        }
        /// <remarks>
        ///  Creates a new Resource object.
        ///  The actual resource data is loaded on demand. Thus, it is possible to work
        ///  with Resources as if they were in memory all the time.
        ///  \param uriOrIdentifier The unique URI or an arbitrary identifier of the resource.
        ///                         If it exists as a resource URI in the RDF store it is used to load the
        ///                         related properties. If not the passed string is treated
        ///                         as an identifier.
        ///                         If a resource exists in the store which has this identifier
        ///                         set this resource's properties are loaded. Otherwise the
        ///                         resource is created in the store
        ///                         with a new random URI which can be accessed through \a uri
        ///                         after the resource has been synced. The resource can later
        ///                         again be found through the same identifier.
        ///                         In Nepomuk there are two ways of identifying a resource
        ///                         uniquely:
        ///                         <li>The</li> URI of the resource which is generated randomly
        ///                         by the framework and can only be accessed in a read-only
        ///                         fashion.
        ///                         <li>An</li> identifier in combination with the resource type (Be
        ///                         aware that this identification can only be guranteed if identifiers
        ///                         are never set manually via addIdentifier but only through the
        ///                         constructor.
        ///  \param type The URI identifying the type of the resource. If it is empty
        ///              Resource falls back to http://www.w3.org/2000/01/rdf-schema\#Resource or
        ///              in case the resource already exists the type will be read from the
        ///              store. (This is a string instead of a QUrl for historical reasons)
        ///  Example:
        ///  The best way to understand the URI and identifier system is through file resources.
        ///  When a Resource object is created with the local path of the file as an identifier:
        ///  <pre>
        ///  Resource myfile( "/tmp/testfile.txt" );
        ///  </pre>
        ///  Now the URI of the resource in the store representing metadata for the file /tmp/testfile.txt
        ///  is referred to by myfile.uri() which differs from the path of the file. However, the path of
        ///  the file is saved as a \a hasIdentifier relation which means that it can be used to easily find
        ///  the related resource.
        ///          </remarks>        <short>    Creates a new Resource object.</short>
        public Resource(string uriOrIdentifier, QUrl type) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource$#", "Resource(const QString&, const QUrl&)", typeof(void), typeof(string), uriOrIdentifier, typeof(QUrl), type);
        }
        public Resource(string uriOrIdentifier) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource$", "Resource(const QString&)", typeof(void), typeof(string), uriOrIdentifier);
        }
        /// <remarks>
        ///  Creates a new Resource object.
        ///  \param url The URI of the resource. If no resource with this URI exists, a new one is
        ///  created.
        ///  \param type The URI identifying the type of the resource. If it is empty
        ///              Resource falls back to http://www.w3.org/2000/01/rdf-schema\#Resource or
        ///              in case the resource already exists the type will be read from the
        ///              store.
        ///          </remarks>        <short>    Creates a new Resource object.</short>
        public Resource(QUrl uri, QUrl type) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource##", "Resource(const QUrl&, const QUrl&)", typeof(void), typeof(QUrl), uri, typeof(QUrl), type);
        }
        public Resource(QUrl uri) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Resource#", "Resource(const QUrl&)", typeof(void), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  The URI of the resource, uniquely identifying it. This URI in most
        ///  cases is a one which has been created from a generic base
        ///  namespace and some identifier.
        ///  the most important thing to remember is that the URI of for example
        ///  a file does not necessarily have a relation to its local path.
        ///  (Although Nepomuk tries to keep the URI of file resources in sync
        ///  with the file URL for convenience.)
        ///  \sa uri, getIdentifiers
        ///          </remarks>        <short>    The URI of the resource, uniquely identifying it.</short>
        public QUrl ResourceUri() {
            return (QUrl) interceptor.Invoke("resourceUri", "resourceUri() const", typeof(QUrl));
        }
        /// <remarks>
        ///  The main type of the resource. Nepomuk tries hard to make this
        ///  the type furthest down the hierarchy. In case the resource has only
        ///  one type, this is no problem. However, if the resource has multiple
        ///  types from different type hierarchies, there is no guarantee which
        ///  one will be used here.
        ///  \sa name(), hasType(), types()
        ///          </remarks>        <short>    The main type of the resource.</short>
        public QUrl ResourceType() {
            return (QUrl) interceptor.Invoke("resourceType", "resourceType() const", typeof(QUrl));
        }
        /// <remarks>
        ///  \return The list of all stored types for this resource. This may
        ///  also include types that lie in the same hierachy.
        ///  \sa type(), hasType()
        ///          </remarks>        <short>    \return The list of all stored types for this resource.</short>
        public List<QUrl> Types() {
            return (List<QUrl>) interceptor.Invoke("types", "types() const", typeof(List<QUrl>));
        }
        /// <remarks>
        ///  Set the types of the resource. Previous types will be overwritten.
        ///  \since 4.2
        ///          </remarks>        <short>    Set the types of the resource.</short>
        public void SetTypes(List<QUrl> types) {
            interceptor.Invoke("setTypes?", "setTypes(const QList<QUrl>&)", typeof(void), typeof(List<QUrl>), types);
        }
        /// <remarks>
        ///  Add a type to the list of types.
        ///  \since 4.2
        ///          </remarks>        <short>    Add a type to the list of types.</short>
        public void AddType(QUrl type) {
            interceptor.Invoke("addType#", "addType(const QUrl&)", typeof(void), typeof(QUrl), type);
        }
        /// <remarks>
        ///  Check if the resource is of a certain type. The type hierarchy
        ///  is checked including subclass relations.
        ///          </remarks>        <short>    Check if the resource is of a certain type.</short>
        public bool HasType(QUrl typeUri) {
            return (bool) interceptor.Invoke("hasType#", "hasType(const QUrl&) const", typeof(bool), typeof(QUrl), typeUri);
        }
        /// <remarks>
        ///  The name of the class this Resource represents an object of.
        ///  The classname is derived from the type URI (see Resource.Uri).
        ///  For a translated user readable name of the resource see
        ///  Ontology.TypeName.
        ///  \sa type()
        ///          </remarks>        <short>    The name of the class this Resource represents an object of.</short>
        public string ClassName() {
            return (string) interceptor.Invoke("className", "className() const", typeof(string));
        }
        /// <remarks>
        ///  \return A list of all defined properties
        ///          </remarks>        <short>    \return A list of all defined properties          </short>
        public Dictionary<QUrl, Nepomuk.Variant> Properties() {
            return (Dictionary<QUrl, Nepomuk.Variant>) interceptor.Invoke("properties", "properties() const", typeof(Dictionary<QUrl, Nepomuk.Variant>));
        }
        /// <remarks>
        ///  Check if property identified by \a uri is defined
        ///  for this resource.
        ///  \param uri The URI identifying the property.
        ///  \return true if property \a uri has a value set.
        ///          </remarks>        <short>    Check if property identified by \a uri is defined  for this resource.</short>
        public bool HasProperty(QUrl uri) {
            return (bool) interceptor.Invoke("hasProperty#", "hasProperty(const QUrl&) const", typeof(bool), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Retrieve the value of property \a uri. If the property is not defined for
        ///  this resource an invalid, empty Variant object is returned.
        ///  \param uri The URI identifying the property.
        ///          </remarks>        <short>    Retrieve the value of property \a uri.</short>
        public Nepomuk.Variant Property(QUrl uri) {
            return (Nepomuk.Variant) interceptor.Invoke("property#", "property(const QUrl&) const", typeof(Nepomuk.Variant), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Set a property of the resource.
        ///  \param uri The URI identifying the property.
        ///  \param value The value of the property (i.e. the object of the RDF triple(s))
        ///          </remarks>        <short>    Set a property of the resource.</short>
        public void SetProperty(QUrl uri, Nepomuk.Variant value) {
            interceptor.Invoke("setProperty##", "setProperty(const QUrl&, const Nepomuk::Variant&)", typeof(void), typeof(QUrl), uri, typeof(Nepomuk.Variant), value);
        }
        /// <remarks>
        ///  Remove property \a uri from this resource object.
        ///  \param uri The URI identifying the property.
        ///          </remarks>        <short>    Remove property \a uri from this resource object.</short>
        public void RemoveProperty(QUrl uri) {
            interceptor.Invoke("removeProperty#", "removeProperty(const QUrl&)", typeof(void), typeof(QUrl), uri);
        }
        /// <remarks>
        ///  Remove this resource completely.
        ///  CAUTION: After calling this method the resource will have been removed from the store
        ///  without any trace.
        ///          </remarks>        <short>    Remove this resource completely.</short>
        public void Remove() {
            interceptor.Invoke("remove", "remove()", typeof(void));
        }
        /// <remarks>
        ///  \return true if this resource (i.e. the uri of this resource) exists in the local
        ///  NEPOMUK RDF store.
        ///          </remarks>        <short>    \return true if this resource (i.</short>
        public bool Exists() {
            return (bool) interceptor.Invoke("exists", "exists() const", typeof(bool));
        }
        /// <remarks>
        ///  \return true if this Resource object is valid, i.e. has a proper URI and type and
        ///  can be synced with the local NEPOMUK RDF store.
        ///  An invalid resource will become valid (i.e. get a new random URI) once setProperty
        ///  is called.
        ///          </remarks>        <short>    \return true if this Resource object is valid, i.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  Tries very hard to find a suitable human-readable label for this resource.
        ///  It looks for properties such as nao:prefLabel, rdfs:label, or nao:identifier,
        ///  or even the fileName of File resources.
        ///  \return A human readable label or if all fails the URI of the resource.
        ///          </remarks>        <short>    Tries very hard to find a suitable human-readable label for this resource.</short>
        public string GenericLabel() {
            return (string) interceptor.Invoke("genericLabel", "genericLabel() const", typeof(string));
        }
        /// <remarks>
        ///  Tries very hard to find a suitable human-readable description of the resource.
        ///  This description is supposed to be longer than genericLabel() and includes such properties
        ///  as nao:description, xesam:comment, rdfs:comment
        ///  \return A human readable description of the resource or an empty string if none
        ///  could be found.
        ///          </remarks>        <short>    Tries very hard to find a suitable human-readable description of the resource.</short>
        public string GenericDescription() {
            return (string) interceptor.Invoke("genericDescription", "genericDescription() const", typeof(string));
        }
        /// <remarks>
        ///  Tries very hard to find an icon suitable for this resource.
        ///  \return An icon name to be used with KIcon or an empty string if none was found.
        ///          </remarks>        <short>    Tries very hard to find an icon suitable for this resource.</short>
        public string GenericIcon() {
            return (string) interceptor.Invoke("genericIcon", "genericIcon() const", typeof(string));
        }
        /// <remarks>
        ///  Get or create the PIMO thing that relates to this resource. If this resource
        ///  itself is a pimo:Thing, a reference to this is returned. If a pimo:Thing exists
        ///  with has as occurrence this resource, the thing is returned. Otherwise a new thing
        ///  is created.
        ///  \since 4.2
        ///          </remarks>        <short>    Get or create the PIMO thing that relates to this resource.</short>
        public Nepomuk.Thing PimoThing() {
            return (Nepomuk.Thing) interceptor.Invoke("pimoThing", "pimoThing()", typeof(Nepomuk.Thing));
        }
        /// <remarks>
        ///  Operator to compare two Resource objects. Normally one does not need this. It is
        ///  mainly intended for testing and debugging purposes.
        ///          </remarks>        <short>    Operator to compare two Resource objects.</short>
        public override bool Equals(object o) {
            if (!(o is Resource)) { return false; }
            return this == (Resource) o;
        }
        public override int GetHashCode() {
            return interceptor.GetHashCode();
        }
        /// <remarks>
        ///  Get property 'description'. Everything can be annotated with 
        ///  a simple string comment. 
        ///          </remarks>        <short>    Get property 'description'.</short>
        public string Description() {
            return (string) interceptor.Invoke("description", "description() const", typeof(string));
        }
        /// <remarks>
        ///  Set property 'description'. Everything can be annotated with 
        ///  a simple string comment. 
        ///          </remarks>        <short>    Set property 'description'.</short>
        public void SetDescription(string value) {
            interceptor.Invoke("setDescription$", "setDescription(const QString&)", typeof(void), typeof(string), value);
        }
        /// <remarks>
        ///  Get property 'identifier'. 
        ///          </remarks>        <short>    Get property 'identifier'.</short>
        public List<string> Identifiers() {
            return (List<string>) interceptor.Invoke("identifiers", "identifiers() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Set property 'identifier'. 
        ///          </remarks>        <short>    Set property 'identifier'.</short>
        public void SetIdentifiers(List<string> value) {
            interceptor.Invoke("setIdentifiers?", "setIdentifiers(const QStringList&)", typeof(void), typeof(List<string>), value);
        }
        /// <remarks>
        ///  Add a value to property 'identifier'. 
        ///          </remarks>        <short>    Add a value to property 'identifier'.</short>
        public void AddIdentifier(string value) {
            interceptor.Invoke("addIdentifier$", "addIdentifier(const QString&)", typeof(void), typeof(string), value);
        }
        /// <remarks>
        ///  Get property 'altLabel'. 
        ///          </remarks>        <short>    Get property 'altLabel'.</short>
        public List<string> AltLabels() {
            return (List<string>) interceptor.Invoke("altLabels", "altLabels() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Set property 'altLabel'. 
        ///          </remarks>        <short>    Set property 'altLabel'.</short>
        public void SetAltLabels(List<string> value) {
            interceptor.Invoke("setAltLabels?", "setAltLabels(const QStringList&)", typeof(void), typeof(List<string>), value);
        }
        /// <remarks>
        ///  Add a value to property 'altLabel'. 
        ///          </remarks>        <short>    Add a value to property 'altLabel'.</short>
        public void AddAltLabel(string value) {
            interceptor.Invoke("addAltLabel$", "addAltLabel(const QString&)", typeof(void), typeof(string), value);
        }
        /// <remarks>
        ///  Get property 'annotation'. 
        ///          </remarks>        <short>    Get property 'annotation'.</short>
        public List<Nepomuk.Resource> Annotations() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("annotations", "annotations() const", typeof(List<Nepomuk.Resource>));
        }
        /// <remarks>
        ///  Set property 'annotation'. 
        ///          </remarks>        <short>    Set property 'annotation'.</short>
        public void SetAnnotations(List<Nepomuk.Resource> value) {
            interceptor.Invoke("setAnnotations?", "setAnnotations(const QList<Nepomuk::Resource>&)", typeof(void), typeof(List<Nepomuk.Resource>), value);
        }
        /// <remarks>
        ///  Add a value to property 'annotation'. 
        ///          </remarks>        <short>    Add a value to property 'annotation'.</short>
        public void AddAnnotation(Nepomuk.Resource value) {
            interceptor.Invoke("addAnnotation#", "addAnnotation(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), value);
        }
        /// <remarks>
        ///  Get property 'Tag'. Each Resource can be tagged with an arbitrary 
        ///  number of Tags. This allows a simple grouping of resources. 
        ///          </remarks>        <short>    Get property 'Tag'.</short>
        public List<Nepomuk.Tag> Tags() {
            return (List<Nepomuk.Tag>) interceptor.Invoke("tags", "tags() const", typeof(List<Nepomuk.Tag>));
        }
        /// <remarks>
        ///  Set property 'Tag'. Each Resource can be tagged with an arbitrary 
        ///  number of Tags. This allows a simple grouping of resources. 
        ///          </remarks>        <short>    Set property 'Tag'.</short>
        public void SetTags(List<Nepomuk.Tag> value) {
            interceptor.Invoke("setTags?", "setTags(const QList<Nepomuk::Tag>&)", typeof(void), typeof(List<Nepomuk.Tag>), value);
        }
        /// <remarks>
        ///  Add a value to property 'Tag'. Each Resource can be tagged with 
        ///  an arbitrary number of Tags. This allows a simple grouping of 
        ///  resources. 
        ///          </remarks>        <short>    Add a value to property 'Tag'.</short>
        public void AddTag(Nepomuk.Tag value) {
            interceptor.Invoke("addTag#", "addTag(const Nepomuk::Tag&)", typeof(void), typeof(Nepomuk.Tag), value);
        }
        /// <remarks>
        ///  Get property 'Topic'. 
        ///          </remarks>        <short>    Get property 'Topic'.</short>
        public List<Nepomuk.Resource> Topics() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("topics", "topics() const", typeof(List<Nepomuk.Resource>));
        }
        /// <remarks>
        ///  Set property 'Topic'. 
        ///          </remarks>        <short>    Set property 'Topic'.</short>
        public void SetTopics(List<Nepomuk.Resource> value) {
            interceptor.Invoke("setTopics?", "setTopics(const QList<Nepomuk::Resource>&)", typeof(void), typeof(List<Nepomuk.Resource>), value);
        }
        /// <remarks>
        ///  Add a value to property 'Topic'. 
        ///          </remarks>        <short>    Add a value to property 'Topic'.</short>
        public void AddTopic(Nepomuk.Resource value) {
            interceptor.Invoke("addTopic#", "addTopic(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), value);
        }
        /// <remarks>
        ///  Get property 'isTopicOf'. 
        ///          </remarks>        <short>    Get property 'isTopicOf'.</short>
        public List<Nepomuk.Resource> IsTopicOfs() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("isTopicOfs", "isTopicOfs() const", typeof(List<Nepomuk.Resource>));
        }
        /// <remarks>
        ///  Set property 'isTopicOf'. 
        ///          </remarks>        <short>    Set property 'isTopicOf'.</short>
        public void SetIsTopicOfs(List<Nepomuk.Resource> value) {
            interceptor.Invoke("setIsTopicOfs?", "setIsTopicOfs(const QList<Nepomuk::Resource>&)", typeof(void), typeof(List<Nepomuk.Resource>), value);
        }
        /// <remarks>
        ///  Add a value to property 'isTopicOf'. 
        ///          </remarks>        <short>    Add a value to property 'isTopicOf'.</short>
        public void AddIsTopicOf(Nepomuk.Resource value) {
            interceptor.Invoke("addIsTopicOf#", "addIsTopicOf(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), value);
        }
        /// <remarks>
        ///  Get property 'isRelated'. 
        ///          </remarks>        <short>    Get property 'isRelated'.</short>
        public List<Nepomuk.Resource> IsRelateds() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("isRelateds", "isRelateds() const", typeof(List<Nepomuk.Resource>));
        }
        /// <remarks>
        ///  Set property 'isRelated'. 
        ///          </remarks>        <short>    Set property 'isRelated'.</short>
        public void SetIsRelateds(List<Nepomuk.Resource> value) {
            interceptor.Invoke("setIsRelateds?", "setIsRelateds(const QList<Nepomuk::Resource>&)", typeof(void), typeof(List<Nepomuk.Resource>), value);
        }
        /// <remarks>
        ///  Add a value to property 'isRelated'. 
        ///          </remarks>        <short>    Add a value to property 'isRelated'.</short>
        public void AddIsRelated(Nepomuk.Resource value) {
            interceptor.Invoke("addIsRelated#", "addIsRelated(const Nepomuk::Resource&)", typeof(void), typeof(Nepomuk.Resource), value);
        }
        /// <remarks>
        ///  Get property 'label'. 
        ///          </remarks>        <short>    Get property 'label'.</short>
        public string Label() {
            return (string) interceptor.Invoke("label", "label() const", typeof(string));
        }
        /// <remarks>
        ///  Set property 'label'. 
        ///          </remarks>        <short>    Set property 'label'.</short>
        public void SetLabel(string value) {
            interceptor.Invoke("setLabel$", "setLabel(const QString&)", typeof(void), typeof(string), value);
        }
        /// <remarks>
        ///  Get property 'Rating'. 
        ///          </remarks>        <short>    Get property 'Rating'.</short>
        public uint Rating() {
            return (uint) interceptor.Invoke("rating", "rating() const", typeof(uint));
        }
        /// <remarks>
        ///  Set property 'Rating'. 
        ///          </remarks>        <short>    Set property 'Rating'.</short>
        public void SetRating(ref int value) {
            StackItem[] stack = new StackItem[2];
            stack[1].s_int = value;
            interceptor.Invoke("setRating$", "setRating(const unsigned int&)", stack);
            value = stack[1].s_int;
            return;
        }
        /// <remarks>
        ///  Get property 'Symbol'. Each resource can have a symbol assigned. 
        ///  For now this is a simple string which can either be the patch to 
        ///  an actual pixmap file or just the name of an icon as defined by 
        ///  the freedesktop.org standard. 
        ///          </remarks>        <short>    Get property 'Symbol'.</short>
        public List<string> Symbols() {
            return (List<string>) interceptor.Invoke("symbols", "symbols() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Set property 'Symbol'. Each resource can have a symbol assigned. 
        ///  For now this is a simple string which can either be the patch to 
        ///  an actual pixmap file or just the name of an icon as defined by 
        ///  the freedesktop.org standard. 
        ///          </remarks>        <short>    Set property 'Symbol'.</short>
        public void SetSymbols(List<string> value) {
            interceptor.Invoke("setSymbols?", "setSymbols(const QStringList&)", typeof(void), typeof(List<string>), value);
        }
        /// <remarks>
        ///  Add a value to property 'Symbol'. Each resource can have a symbol 
        ///  assigned. For now this is a simple string which can either be 
        ///  the patch to an actual pixmap file or just the name of an icon as 
        ///  defined by the freedesktop.org standard. 
        ///          </remarks>        <short>    Add a value to property 'Symbol'.</short>
        public void AddSymbol(string value) {
            interceptor.Invoke("addSymbol$", "addSymbol(const QString&)", typeof(void), typeof(string), value);
        }
        /// <remarks>
        ///  Get all resources that have this resource set as property 'annotation'. 
        ///  \sa ResourceManager.AllResourcesWithProperty 
        ///          </remarks>        <short>    Get all resources that have this resource set as property 'annotation'.</short>
        public List<Nepomuk.Resource> AnnotationOf() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("annotationOf", "annotationOf() const", typeof(List<Nepomuk.Resource>));
        }
        /// <remarks>
        ///  Get all resources that have this resource set as property 'isRelated'. 
        ///  \sa ResourceManager.AllResourcesWithProperty 
        ///          </remarks>        <short>    Get all resources that have this resource set as property 'isRelated'.</short>
        public List<Nepomuk.Resource> IsRelatedOf() {
            return (List<Nepomuk.Resource>) interceptor.Invoke("isRelatedOf", "isRelatedOf() const", typeof(List<Nepomuk.Resource>));
        }
        ~Resource() {
            interceptor.Invoke("~Resource", "~Resource()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Resource", "~Resource()", typeof(void));
        }
        public static bool operator==(Resource lhs, Nepomuk.Resource arg1) {
            return (bool) staticInterceptor.Invoke("operator==#", "operator==(const Nepomuk::Resource&) const", typeof(bool), typeof(Resource), lhs, typeof(Nepomuk.Resource), arg1);
        }
        public static bool operator!=(Resource lhs, Nepomuk.Resource arg1) {
            return !(bool) staticInterceptor.Invoke("operator==#", "operator==(const Nepomuk::Resource&) const", typeof(bool), typeof(Resource), lhs, typeof(Nepomuk.Resource), arg1);
        }
        /// <remarks>
        ///  \return The URI of the property 'description'. 
        ///          </remarks>        <short>    \return The URI of the property 'description'.</short>
        public static string DescriptionUri() {
            return (string) staticInterceptor.Invoke("descriptionUri", "descriptionUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'identifier'. 
        ///          </remarks>        <short>    \return The URI of the property 'identifier'.</short>
        public static string IdentifierUri() {
            return (string) staticInterceptor.Invoke("identifierUri", "identifierUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'altLabel'. 
        ///          </remarks>        <short>    \return The URI of the property 'altLabel'.</short>
        public static string AltLabelUri() {
            return (string) staticInterceptor.Invoke("altLabelUri", "altLabelUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'annotation'. 
        ///          </remarks>        <short>    \return The URI of the property 'annotation'.</short>
        public static string AnnotationUri() {
            return (string) staticInterceptor.Invoke("annotationUri", "annotationUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'Tag'. 
        ///          </remarks>        <short>    \return The URI of the property 'Tag'.</short>
        public static string TagUri() {
            return (string) staticInterceptor.Invoke("tagUri", "tagUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'Topic'. 
        ///          </remarks>        <short>    \return The URI of the property 'Topic'.</short>
        public static string TopicUri() {
            return (string) staticInterceptor.Invoke("topicUri", "topicUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'isTopicOf'. 
        ///          </remarks>        <short>    \return The URI of the property 'isTopicOf'.</short>
        public static string IsTopicOfUri() {
            return (string) staticInterceptor.Invoke("isTopicOfUri", "isTopicOfUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'isRelated'. 
        ///          </remarks>        <short>    \return The URI of the property 'isRelated'.</short>
        public static string IsRelatedUri() {
            return (string) staticInterceptor.Invoke("isRelatedUri", "isRelatedUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'label'. 
        ///          </remarks>        <short>    \return The URI of the property 'label'.</short>
        public static string LabelUri() {
            return (string) staticInterceptor.Invoke("labelUri", "labelUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'Rating'. 
        ///          </remarks>        <short>    \return The URI of the property 'Rating'.</short>
        public static string RatingUri() {
            return (string) staticInterceptor.Invoke("ratingUri", "ratingUri()", typeof(string));
        }
        /// <remarks>
        ///  \return The URI of the property 'Symbol'. 
        ///          </remarks>        <short>    \return The URI of the property 'Symbol'.</short>
        public static string SymbolUri() {
            return (string) staticInterceptor.Invoke("symbolUri", "symbolUri()", typeof(string));
        }
        /// <remarks>
        ///  Retrieve a list of all available Resource resources. This list 
        ///  consists of all resource of type Resource that are stored in 
        ///  the local Nepomuk meta data storage and any changes made locally. 
        ///  Be aware that in some cases this list can get very big. Then it 
        ///  might be better to use libKNep directly. 
        ///          </remarks>        <short>    Retrieve a list of all available Resource resources.</short>
        public static List<Nepomuk.Resource> AllResources() {
            return (List<Nepomuk.Resource>) staticInterceptor.Invoke("allResources", "allResources()", typeof(List<Nepomuk.Resource>));
        }
    }
}
