/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%              PPPP    AAA   TTTTT  TTTTT  EEEEE  RRRR   N   N                %
%              P   P  A   A    T      T    E      R   R  NN  N                %
%              PPPP   AAAAA    T      T    EEE    RRRR   N N N                %
%              P      A   A    T      T    E      R R    N  NN                %
%              P      A   A    T      T    EEEEE  R  R   N   N                %
%                                                                             %
%                                                                             %
%                      Read/Write Pattern Image Format                        %
%                                                                             %
%                              Software Design                                %
%                                John Cristy                                  %
%                                 May 2003                                    %
%                                                                             %
%                                                                             %
%  Copyright 1999-2009 ImageMagick Studio LLC, a non-profit organization      %
%  dedicated to making software imaging solutions freely available.           %
%                                                                             %
%  You may not use this file except in compliance with the License.  You may  %
%  obtain a copy of the License at                                            %
%                                                                             %
%    http://www.imagemagick.org/script/license.php                            %
%                                                                             %
%  Unless required by applicable law or agreed to in writing, software        %
%  distributed under the License is distributed on an "AS IS" BASIS,          %
%  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   %
%  See the License for the specific language governing permissions and        %
%  limitations under the License.                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
*/

/*
  Include declarations.
*/
#include "magick/studio.h"
#include "magick/blob.h"
#include "magick/blob-private.h"
#include "magick/exception.h"
#include "magick/exception-private.h"
#include "magick/image.h"
#include "magick/image-private.h"
#include "magick/list.h"
#include "magick/magick.h"
#include "magick/memory_.h"
#include "magick/quantum-private.h"
#include "magick/static.h"
#include "magick/string_.h"
#include "magick/module.h"

/*
  Bricks pattern.
*/
static const unsigned char
  BricksImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x00, 0x01, 0x00,
    0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0xFF,
    0xFF, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
    0x00, 0x01, 0x00, 0xFF, 0xFF
  };

/*
  Checkerboard pattern.
*/
static const unsigned char
  CheckerboardImage[]=
  {
    0x47, 0x49, 0x46, 0x38, 0x37, 0x61, 0x1E, 0x00, 0x1E, 0x00, 0xF0, 0x01,
    0x00, 0x66, 0x66, 0x66, 0x99, 0x99, 0x99, 0x21, 0xF9, 0x04, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x1E, 0x00,
    0x00, 0x02, 0x42, 0x8C, 0x8F, 0x09, 0xCB, 0xED, 0x09, 0x91, 0x9B, 0x2D,
    0x5A, 0x8A, 0x6D, 0xC4, 0x54, 0x43, 0x3E, 0x79, 0x0A, 0x58, 0x89, 0x07,
    0x59, 0x9A, 0x01, 0xCA, 0xA8, 0x06, 0xBB, 0xB8, 0x2B, 0x2C, 0xC3, 0x40,
    0x4D, 0xBB, 0x36, 0xCE, 0xF2, 0x36, 0xEA, 0x23, 0x05, 0x41, 0x43, 0x4E,
    0x31, 0xA3, 0xCB, 0xA9, 0x76, 0xC9, 0x5E, 0x13, 0xF8, 0x14, 0x46, 0x89,
    0x53, 0x63, 0x15, 0xB9, 0x54, 0x9A, 0x98, 0xAA, 0x02, 0x00, 0x3B
  };

/*
  Circles pattern.
*/
static const unsigned char
  CirclesImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x07, 0xF0, 0x18,
    0x0C, 0x20, 0x02, 0x40, 0x01, 0x40, 0x01, 0x80, 0x00, 0x80, 0x00, 0x80,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x40,
    0x01, 0x20, 0x02, 0x18, 0x0C
  };

/*
  CrossHatch pattern.
*/
static const unsigned char
  CrossHatchImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xFF, 0x11, 0x11, 0x11
  };

/*
  CrossHatch30 pattern.
*/
static const unsigned char
  CrossHatch30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0x81, 0x66, 0x18, 0x66
  };

/*
  CrossHatch45 pattern.
*/
static const unsigned char
  CrossHatch45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x88, 0x50, 0x20, 0x50, 0x88,
    0x05, 0x02, 0x05
  };

/*
  FishScales pattern.
*/
static const unsigned char
  FishScalesImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x38, 0x0A, 0x02, 0x40, 0x0C, 0x30,
    0x70, 0x0E, 0x80, 0x01, 0x40, 0x02, 0x30, 0x0C, 0x0E, 0x70, 0x01, 0x80
  };

/*
  Gray100 pattern.
*/
static const unsigned char
  Gray100Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00
  };

/*
  Gray95 pattern.
*/
static const unsigned char
  Gray95Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10,
    0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x10, 0x10, 0x10, 0x10
  };

/*
  Gray90 pattern.
*/
static const unsigned char
  Gray90Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x08, 0x08, 0x08,
    0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x88, 0x80, 0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80,
    0x80, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x80, 0x88, 0x80, 0x88, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
    0x08, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00
  };

/*
  Gray85 pattern.
*/
static const unsigned char
  Gray85Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x88, 0x8A, 0x88, 0x8A, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0x8A, 0x88, 0x8A,
    0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0x88, 0x8A, 0x88, 0x8A, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8,
    0xA8, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00,
    0x00, 0x8A, 0x88, 0x8A, 0x88, 0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22,
    0x22, 0x00, 0x00, 0x00, 0x00, 0xA8, 0xA8, 0xA8, 0xA8, 0x00, 0x00, 0x00,
    0x00, 0x22, 0x22, 0x22, 0x22
  };

/*
  Gray80 pattern.
*/
static const unsigned char
  Gray80Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x11, 0x51,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55,
    0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51, 0x51, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11,
    0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x51, 0x11, 0x51, 0x11, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55,
    0x55, 0x00, 0x00, 0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,
    0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x51, 0x51, 0x51,
    0x51, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x55, 0x55, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x11, 0x11, 0x11
  };

/*
  Gray75 pattern.
*/
static const unsigned char
  Gray75Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00
  };

/*
  Gray70 pattern.
*/
static const unsigned char
  Gray70Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x01, 0x11,
    0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00,
    0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x00, 0x00, 0x00, 0x00, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x01, 0x11, 0x01
  };

/*
  Gray65 pattern.
*/
static const unsigned char
  Gray65Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x10, 0x11,
    0x10, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x10, 0x10, 0x10, 0x10, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01,
    0x01, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x10, 0x11, 0x10, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x44, 0x44,
    0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x01, 0x01, 0x01, 0x01, 0xAA, 0xAA, 0xAA,
    0xAA, 0x44, 0x44, 0x44, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x10, 0x10, 0x10,
    0x10, 0xAA, 0xAA, 0xAA, 0xAA
  };

/*
  Gray60 pattern.
*/
static const unsigned char
  Gray60Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x45, 0x44, 0x45, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54,
    0x54, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x45, 0x44, 0x45, 0x44, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54, 0x54, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x44, 0x45, 0x44,
    0x45, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA,
    0xAA, 0x54, 0x54, 0x54, 0x54, 0xAA, 0xAA, 0xAA, 0xAA, 0x11, 0x11, 0x11,
    0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x45, 0x44, 0x45, 0x44, 0xAA, 0xAA, 0xAA,
    0xAA, 0x11, 0x11, 0x11, 0x11, 0xAA, 0xAA, 0xAA, 0xAA, 0x54, 0x54, 0x54,
    0x54, 0xAA, 0xAA, 0xAA, 0xAA
  };

/*
  Gray55 pattern.
*/
static const unsigned char
  Gray55Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x2A, 0x2A, 0x2A,
    0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x22, 0x22, 0x22, 0x22, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x2A, 0x22, 0x2A, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x22, 0x22,
    0x22, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x2A, 0x2A, 0x2A, 0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x22, 0x22, 0x22, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0x22, 0x2A, 0x22,
    0x2A, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0x22, 0x22, 0x22, 0x22
  };

/*
  Gray50 pattern.
*/
static const unsigned char
  Gray50Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55
  };

/*
  Gray45 pattern.
*/
static const unsigned char
  Gray45Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xBB, 0xBB, 0xBB,
    0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBB, 0xBB, 0xBB, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xAB, 0xBB,
    0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xBB, 0xBB, 0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBB, 0xBB,
    0xBB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA, 0xAA, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xAB, 0xBB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xAA, 0xAA, 0xAA,
    0xAA, 0x55, 0x55, 0x55, 0x55
  };

/*
  Gray40 pattern.
*/
static const unsigned char
  Gray40Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xBB, 0xBA, 0xBB,
    0xBA, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xBA, 0xBB, 0xBA, 0xBB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB,
    0xAB, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xBB, 0xBA, 0xBB, 0xBA, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xAB, 0xAB, 0xAB, 0xAB, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xBA, 0xBB, 0xBA,
    0xBB, 0x55, 0x55, 0x55, 0x55
  };

/*
  Gray35 pattern.
*/
static const unsigned char
  Gray35Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F,
    0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0x77, 0xF7, 0x77, 0xF7, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD,
    0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F, 0x7F, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0xF7, 0xF7, 0xF7,
    0xF7, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0x7F, 0x7F, 0x7F, 0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD,
    0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x77, 0xF7, 0x77, 0xF7, 0xAA, 0xAA, 0xAA,
    0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA, 0xAA, 0x7F, 0x7F, 0x7F,
    0x7F, 0xAA, 0xAA, 0xAA, 0xAA, 0xDD, 0xDD, 0xDD, 0xDD, 0xAA, 0xAA, 0xAA,
    0xAA, 0xF7, 0xF7, 0xF7, 0xF7
  };

/*
  Gray30 pattern.
*/
static const unsigned char
  Gray30Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xFE, 0xEE,
    0xFE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFE, 0xFE, 0xFE, 0xFE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE,
    0xEE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xEE, 0xFE, 0xEE, 0xFE, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xEE, 0xEE, 0xEE, 0xEE, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFE, 0xFE, 0xFE,
    0xFE, 0x55, 0x55, 0x55, 0x55
  };

/*
  Gray25 pattern.
*/
static const unsigned char
  Gray25Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55,
    0x55, 0xFF, 0xFF, 0xFF, 0xFF, 0x55, 0x55, 0x55, 0x55, 0xFF, 0xFF, 0xFF,
    0xFF, 0x55, 0x55, 0x55, 0x55
  };

/*
  Gray20 pattern.
*/
static const unsigned char
  Gray20Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBB, 0xBA,
    0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA, 0xBA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB,
    0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF,
    0xFF, 0xBA, 0xBB, 0xBA, 0xBB, 0xFF, 0xFF, 0xFF, 0xFF, 0xAA, 0xAA, 0xAA,
    0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBB, 0xBB, 0xBB, 0xBB, 0xFF, 0xFF, 0xFF,
    0xFF, 0xAA, 0xAA, 0xAA, 0xAA, 0xFF, 0xFF, 0xFF, 0xFF, 0xBA, 0xBA, 0xBA,
    0xBA, 0xFF, 0xFF, 0xFF, 0xFF
  };

/*
  Gray15 pattern.
*/
static const unsigned char
  Gray15Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xD5, 0xDD, 0xD5,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xD5, 0xDD, 0xD5, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D,
    0x5D, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xD5, 0xDD, 0xD5, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0x5D, 0x5D, 0x5D, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xD5, 0xDD,
    0xD5, 0xFF, 0xFF, 0xFF, 0xFF
  };

/*
  Gray10 pattern.
*/
static const unsigned char
  Gray10Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xDD, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFD, 0xFD,
    0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77,
    0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xDD, 0xFD, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0x77, 0x77, 0x77, 0x77, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFD, 0xFD, 0xFD, 0xFD
  };

/*
  Gray5 pattern.
*/
static const unsigned char
  Gray5Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF,
    0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDD, 0xDD, 0xDD, 0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xDF, 0xDF, 0xDF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDD, 0xDD, 0xDD,
    0xDD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xDF, 0xDF, 0xDF, 0xDF
  };

/*
  Gray0 pattern.
*/
static const unsigned char
  Gray0Image[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x32, 0x20, 0x33, 0x32, 0x0A, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF
  };

/*
  Hexagons pattern.
*/
static const unsigned char
  HexagonsImage[] =
  {
    0x50, 0x34, 0x0A, 0x33, 0x30, 0x20, 0x31, 0x38, 0x0A, 0x10, 0x01, 0x00,
    0x00, 0x10, 0x01, 0x00, 0x00, 0x20, 0x00, 0x80, 0x00, 0x20, 0x00, 0x80,
    0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x80, 0x00, 0x20,
    0x00, 0x80, 0x00, 0x20, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x80, 0x00, 0x20,
    0x00, 0x80, 0x00, 0x20, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40, 0x00, 0x40,
    0x00, 0x20, 0x00, 0x80, 0x00, 0x20, 0x00, 0x80, 0x00, 0x10, 0x01, 0x00,
    0x00, 0x10, 0x01, 0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00
  };

/*
  Horizontal pattern.
*/
static const unsigned char
  HorizontalImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xFF, 0x00, 0x00, 0x00
  };

/*
  HorizontalSaw pattern.
*/
static const unsigned char
  HorizontalSawImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x38, 0x0A, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x10, 0x10, 0x28, 0x28, 0x44, 0x44, 0x82, 0x82, 0x01, 0x01
  };

/*
  HS_BDIAGONAL pattern (Windows GDI HS_BDIAGONAL)
*/
static const unsigned char
  HS_BDIAGONALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80
  };

/*
  HS_CROSS pattern (Windows GDI HS_CROSS)
*/
static const unsigned char
  HS_CROSSImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x10, 0x10, 0x10, 0xFF, 0x10,
    0x10, 0x10, 0x10
  };

/*
  HS_DIAGCROSS pattern (Windows GDI HS_DIAGCROSS)
*/
static const unsigned char
  HS_DIAGCROSSImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x81, 0x42, 0x24, 0x18, 0x18,
    0x24, 0x42, 0x81
  };

/*
  HS_FDIAGONAL pattern (Windows GDI HS_FDIAGONAL)
*/
static const unsigned char
  HS_FDIAGONALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x40, 0x20, 0x10, 0x08,
    0x04, 0x02, 0x01
  };

/*
  HS_HORIZONTAL pattern (Windows GDI HS_HORIZONTAL)
*/
static const unsigned char
  HS_HORIZONTALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x00, 0x00, 0x00, 0xFF, 0x00,
    0x00, 0x00, 0x00
  };

/*
  HS_VERTICAL pattern (Windows GDI HS_VERTICAL)
*/
static const unsigned char
  HS_VERTICALImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10
  };

/*
  Left30 pattern.
*/
static const unsigned char
  Left30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0xC0, 0x30, 0x0C, 0x03
  };

/*
  Left45 pattern.
*/
static const unsigned char
  Left45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x40, 0x20, 0x10, 0x08,
    0x04, 0x02, 0x01
  };

/*
  LeftShingle pattern.
*/
static const unsigned char
  LeftShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x00, 0x00, 0x01,
    0x00, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04,
    0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0x00,
    0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x00,
    0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0x00,
    0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0xFF, 0xFF, 0xFF
  };

/*
  Octagons image declaration.
*/
static const unsigned char
  OctagonsImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0x07, 0xF0, 0x08,
    0x08, 0x10, 0x04, 0x20, 0x02, 0x40, 0x01, 0x80, 0x00, 0x80, 0x00, 0x80,
    0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x40, 0x01, 0x20,
    0x02, 0x10, 0x04, 0x08, 0x08
  };

/*
  Right30 pattern.
*/
static const unsigned char
  Right30Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x34, 0x0A, 0x03, 0x0C, 0x30, 0xC0
  };

/*
  Right45 pattern.
*/
static const unsigned char
  Right45Image[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x01, 0x02, 0x04, 0x08, 0x10,
    0x20, 0x40, 0x80
  };

/*
  RightShingle pattern.
*/
static const unsigned char
  RightShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x00, 0x00, 0x08,
    0x00, 0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x00, 0x08, 0x00,
    0x00, 0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00,
    0x00, 0x02, 0x00, 0x00, 0x01, 0x00, 0xFF, 0xFF, 0xFF, 0x08, 0x00, 0x00,
    0x08, 0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00,
    0x02, 0x00, 0x00, 0x01, 0x00, 0x00, 0xFF, 0xFF, 0xFF
  };

/*
  SmallFishScales pattern.
*/
static const unsigned char
  SmallFishScalesImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x80, 0x80, 0x41, 0x36, 0x08,
    0x08, 0x14, 0x63
  };

/*
  Vertical pattern.
*/
static const unsigned char
  VerticalImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x38, 0x0A, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11
  };

/*
  VerticalBricks pattern.
*/
static const unsigned char
  VerticalBricksImage[] =
  {
    0x50, 0x34, 0x0A, 0x31, 0x36, 0x20, 0x31, 0x36, 0x0A, 0xFF, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01
  };

/*
  VerticalLeftShingle pattern.
*/
static const unsigned char
  VerticalLeftShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81,
    0x01, 0x01, 0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x01,
    0x01, 0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x01, 0x01,
    0x61, 0x01, 0x01, 0x19, 0x01, 0x01, 0x07, 0x01, 0x01
  };

/*
  VerticalRightShingle pattern.
*/
static const unsigned char
  VerticalRightShingleImage[] =
  {
    0x50, 0x34, 0x0A, 0x32, 0x34, 0x20, 0x32, 0x34, 0x0A, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01,
    0x01, 0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03,
    0x01, 0x01, 0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x01,
    0x0D, 0x01, 0x01, 0x31, 0x01, 0x01, 0xC1, 0x01, 0x01
  };

/*
  VerticalSaw pattern.
*/
static const unsigned char
  VerticalSawImage[] =
  {
    0x50, 0x34, 0x0A, 0x38, 0x20, 0x31, 0x36, 0x0A, 0x40, 0x20, 0x10, 0x08,
    0x10, 0x20, 0x40, 0x80, 0x40, 0x20, 0x10, 0x08, 0x10, 0x20, 0x40, 0x80
  };

typedef struct _PatternInfo
{
  char
    name[MaxTextExtent],
    magick[MaxTextExtent];

  const void
    *blob;

  size_t
    extent;
} PatternInfo;

static const PatternInfo
  PatternImageList[] =
  {
    { "BRICKS", "PBM", BricksImage, sizeof(BricksImage) },
    { "CHECKERBOARD", "GIF", CheckerboardImage, sizeof(CheckerboardImage) },
    { "CIRCLES", "PBM", CirclesImage, sizeof(CirclesImage) },
    { "CROSSHATCH", "PBM", CrossHatchImage, sizeof(CrossHatchImage) },
    { "CROSSHATCH30", "PBM", CrossHatch30Image, sizeof(CrossHatch30Image) },
    { "CROSSHATCH45", "PBM", CrossHatch45Image, sizeof(CrossHatch45Image) },
    { "FISHSCALES", "PBM", FishScalesImage, sizeof(FishScalesImage) },
    { "GRAY0", "PBM", Gray0Image, sizeof(Gray0Image) },
    { "GRAY5", "PBM", Gray5Image, sizeof(Gray5Image) },
    { "GRAY10", "PBM", Gray10Image, sizeof(Gray10Image) },
    { "GRAY15", "PBM", Gray15Image, sizeof(Gray15Image) },
    { "GRAY20", "PBM", Gray20Image, sizeof(Gray20Image) },
    { "GRAY25", "PBM", Gray25Image, sizeof(Gray25Image) },
    { "GRAY30", "PBM", Gray30Image, sizeof(Gray30Image) },
    { "GRAY35", "PBM", Gray35Image, sizeof(Gray35Image) },
    { "GRAY40", "PBM", Gray40Image, sizeof(Gray40Image) },
    { "GRAY45", "PBM", Gray45Image, sizeof(Gray45Image) },
    { "GRAY50", "PBM", Gray50Image, sizeof(Gray50Image) },
    { "GRAY55", "PBM", Gray55Image, sizeof(Gray55Image) },
    { "GRAY60", "PBM", Gray60Image, sizeof(Gray60Image) },
    { "GRAY65", "PBM", Gray65Image, sizeof(Gray65Image) },
    { "GRAY70", "PBM", Gray70Image, sizeof(Gray70Image) },
    { "GRAY75", "PBM", Gray75Image, sizeof(Gray75Image) },
    { "GRAY80", "PBM", Gray80Image, sizeof(Gray80Image) },
    { "GRAY85", "PBM", Gray85Image, sizeof(Gray85Image) },
    { "GRAY90", "PBM", Gray90Image, sizeof(Gray90Image) },
    { "GRAY95", "PBM", Gray95Image, sizeof(Gray95Image) },
    { "GRAY100", "PBM", Gray100Image, sizeof(Gray100Image) },
    { "HEXAGONS", "PBM", HexagonsImage, sizeof(HexagonsImage) },
    { "HORIZONTAL", "PBM", HorizontalImage, sizeof(HorizontalImage) },
    { "HORIZONTALSAW", "PBM", HorizontalSawImage, sizeof(HorizontalSawImage) },
    { "HS_BDIAGONAL", "PBM", HS_BDIAGONALImage, sizeof(HS_BDIAGONALImage) },
    { "HS_CROSS", "PBM", HS_CROSSImage, sizeof(HS_CROSSImage) },
    { "HS_DIAGCROSS", "PBM", HS_DIAGCROSSImage, sizeof(HS_DIAGCROSSImage) },
    { "HS_FDIAGONAL", "PBM", HS_FDIAGONALImage, sizeof(HS_FDIAGONALImage) },
    { "HS_HORIZONTAL", "PBM", HS_HORIZONTALImage, sizeof(HS_HORIZONTALImage) },
    { "HS_VERTICAL", "PBM", HS_VERTICALImage, sizeof(HS_VERTICALImage) },
    { "LEFT30", "PBM", Left30Image, sizeof(Left30Image) },
    { "LEFT45", "PBM", Left45Image, sizeof(Left45Image) },
    { "LEFTSHINGLE", "PBM", LeftShingleImage, sizeof(LeftShingleImage) },
    { "OCTAGONS", "PBM", OctagonsImage, sizeof(OctagonsImage) },
    { "RIGHT30", "PBM", Right30Image, sizeof(Right30Image) },
    { "RIGHT45", "PBM", Right45Image, sizeof(Right45Image) },
    { "RIGHTSHINGLE", "PBM", RightShingleImage, sizeof(RightShingleImage) },
    { "SMALLFISHSCALES", "PBM", SmallFishScalesImage,
      sizeof(SmallFishScalesImage) },
    { "VERTICAL", "PBM", VerticalImage, sizeof(VerticalImage) },
    { "VERTICALBRICKS", "PBM", VerticalBricksImage,
      sizeof(VerticalBricksImage) },
    { "VERTICALLEFTSHINGLE", "PBM", VerticalLeftShingleImage,
      sizeof(VerticalLeftShingleImage) },
    { "VERTICALRIGHTSHINGLE", "PBM", VerticalRightShingleImage,
      sizeof(VerticalRightShingleImage) },
    { "VERTICALSAW", "PBM", VerticalSawImage, sizeof(VerticalSawImage) },
    { "", "", (const void *) NULL, 0 }
  };

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   R e a d P A T T E R N I m a g e                                           %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  ReadPATTERNImage() reads a PATTERN image file and returns it.  It
%  allocates the memory necessary for the new Image structure and returns a
%  pointer to the new image.
%
%  The format of the ReadPATTERNImage method is:
%
%      Image *ReadPATTERNImage(const ImageInfo *image_info,
%        ExceptionInfo *exception)
%
%  A description of each parameter follows:
%
%    o image_info: the image info.
%
%    o exception: return any errors or warnings in this structure.
%
*/
static Image *ReadPATTERNImage(const ImageInfo *image_info,
  ExceptionInfo *exception)
{
  const void
    *blob;

  Image
    *image;

  ImageInfo
    *blob_info;

  register long
    i;

  size_t
    extent;

  blob_info=CloneImageInfo(image_info);
  image=(Image *) NULL;
  blob=(const void *) NULL;
  extent=0;
  for (i=0; PatternImageList[i].blob != (const void *) NULL; i++)
    if (LocaleCompare(blob_info->filename,PatternImageList[i].name) == 0)
      {
        (void) CopyMagickString(blob_info->magick,PatternImageList[i].magick,
          MaxTextExtent);
        blob=PatternImageList[i].blob;
        extent=PatternImageList[i].extent;
        break;
      }
  if (blob == (const void *) NULL)
    ThrowReaderException(OptionError,"UnrecognizedImageFormat");
  image=BlobToImage(blob_info,blob,extent,exception);
  if (image_info->size != (char *) NULL)
    {
      Image
        *pattern_image;

      /*
        Tile pattern across image canvas.
      */
      pattern_image=image;
      image=AcquireImage(blob_info);
      image->background_color=pattern_image->background_color;
      (void) SetImageBackgroundColor(image);
      (void) TextureImage(image,pattern_image);
      pattern_image=DestroyImage(pattern_image);
    }
  blob_info=DestroyImageInfo(blob_info);
  return(GetFirstImageInList(image));
}
/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   R e g i s t e r P A T T E R N I m a g e                                   %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  RegisterPATTERNImage() adds attributes for the BRICKS, CHECKERBOARD,
%  CIRCLES, etc., image formats to the list of supported formats. The attributes
%  include the image format tag, a method to read and/or write the format,
%  whether the format supports the saving of more than one frame to the same
%  file or blob, whether the format supports native in-memory I/O, and a
%  brief description of the format.
%
%  The format of the RegisterPATTERNImage method is:
%
%      unsigned long RegisterPATTERNImage(void)
%
*/
ModuleExport unsigned long RegisterPATTERNImage(void)
{
  MagickInfo
    *entry;

  entry=SetMagickInfo("PATTERN");
  entry->decoder=(DecodeImageHandler *) ReadPATTERNImage;
  entry->adjoin=MagickFalse;
  entry->description=ConstantString("Predefined pattern");
  entry->module=ConstantString("PATTERN");
  (void) RegisterMagickInfo(entry);
  return(MagickImageCoderSignature);
}

/*
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                             %
%                                                                             %
%                                                                             %
%   U n r e g i s t e r P A T T E R N I m a g e                               %
%                                                                             %
%                                                                             %
%                                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  UnregisterPATTERNImage() removes format registrations made by the
%  PATTERN module from the list of supported formats.
%
%  The format of the UnregisterPATTERNImage method is:
%
%      UnregisterPATTERNImage(void)
%
*/
ModuleExport void UnregisterPATTERNImage(void)
{
  (void) UnregisterMagickInfo("PATTERN");
}
