.\" Copyright \(co 2006 Josh Triplett
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.TH XSetEventQueueOwner __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetEventQueueOwner \- set event queue owner on a shared Xlib/XCB connection
.SH SYNTAX
.HP
 #include <X11/Xlib-xcb.h>
.HP
void XSetEventQueueOwner(Display *\fIdpy\fP, enum XEventQueueOwner \fIowner\fP); 
.SH ARGUMENTS
.IP \fIdpy\fP 1i
Specifies the connection to the X server.
.IP \fIowner\fP 1i
Specifies the event queue ownership:
.RS
.TP
\fIXlibOwnsEventQueue\fP (default)
Xlib owns the event queue.  Use the Xlib event-handling functions.  Do not
call the XCB event-handling functions.
.TP
\fIXCBOwnsEventQueue\fP
XCB owns the event queue.  Use the XCB event-handling functions.  Do not call
the Xlib event-handling functions.
.RE
.IN "Environment" "DISPLAY"
.SH DESCRIPTION
While a client using Xlib/XCB can issue requests and handle their replies or
errors with either Xlib or XCB, only one can own and handle the event queue.
By default, Xlib must own the event queue, for compatibility with legacy Xlib
clients.  Clients can call \fIXSetEventQueueOwner\fP immediately after
\fIXOpenDisplay\fP to let XCB own the event queue instead.  Clients may not
call \fIXSetEventQueueOwner\fP at any other time, as this will potentially
lose responses.
.SH "SEE ALSO"
XOpenDisplay(__libmansuffix__),
XGetXCBConnection(__libmansuffix__),
.br
\fIXlib \- C Language X Interface\fP
