/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.SameTerm;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.ValueConstant;
import org.openrdf.query.algebra.ValueExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class CompareOptimizer
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new CompareVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CompareVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected CompareVisitor() {
        }

        @Override
        public void meet(Compare compare) {
            super.meet(compare);
            if (compare.getOperator() == Compare.CompareOp.EQ) {
                ValueExpr leftArg = compare.getLeftArg();
                ValueExpr rightArg = compare.getRightArg();
                boolean leftIsVar = this.isVar(leftArg);
                boolean rightIsVar = this.isVar(rightArg);
                boolean leftIsResource = this.isResource(leftArg);
                boolean rightIsResource = this.isResource(rightArg);
                if (leftIsVar && rightIsResource || leftIsResource && rightIsVar || leftIsResource && rightIsResource) {
                    SameTerm sameTerm = new SameTerm(leftArg, rightArg);
                    compare.replaceWith(sameTerm);
                }
            }
        }

        protected boolean isVar(ValueExpr valueExpr) {
            return valueExpr instanceof Var;
        }

        protected boolean isResource(ValueExpr valueExpr) {
            Value value;
            return valueExpr instanceof ValueConstant && (value = ((ValueConstant)valueExpr).getValue()) instanceof Resource;
        }
    }
}

