//
// "$Id: driver.h,v 1.5 2005/06/17 20:54:20 mike Exp $"
//
//   Common definitions for the CUPS printer driver for Windows.
//
//   Copyright 2001-2005 by Easy Software Products.
//
//   These coded instructions, statements, and computer programs are the
//   property of Easy Software Products and are protected by Federal
//   copyright law.  Distribution and use rights are outlined in the file
//   "LICENSE.txt" which should have been included with this file.  If this
//   file is missing or damaged please contact Easy Software Products
//   at:
//
//       Attn: CUPS Licensing Information
//       Easy Software Products
//       44141 Airport View Drive, Suite 204
//       Hollywood, Maryland 20636 USA
//
//       Voice: (301) 373-9600
//       EMail: cups-info@cups.org
//         WWW: http://www.cups.org/
//

#ifndef _COMMON_DRIVER_H_
#  define _COMMON_DRIVER_H_

//
// Include necessary headers...
//

#  include <stdio.h>
#  include <stdarg.h>
#  include <stddef.h>
#  define INITGUID
#  include <objbase.h>
#  include <windef.h>
#  include <winerror.h>
#  include <winbase.h>
#  include <wingdi.h>
extern "C" 
{
#  include <winddi.h>
}
#  include <winspool.h>
#  include <tchar.h>
#  include <assert.h>
#  include <prsht.h>
#  include <compstui.h>
#  include <winddiui.h>
#  include <printoem.h>
#  include <prcomoem.h>


//
// Definitions...
//

#  define CUPS_PROFILE		L"srgb.icm\0"
					// Color profile to use
#  define CUPS_SIGNATURE	'CUPS'	// Vendor signature
#  define CUPS_WINVERSION	0x0600	// Version number (MMmm in hex)


//
// Data types...
//

struct cups_dev_t			//// CUPS driver device data
{
  OEM_DMEXTRAHEADER dm_extra;		// Common header for extension data

  WCHAR	page_label[128];		// page-label attribute
  WCHAR	job_billing[128];		// job-billing attribute
};

class cupsCF : public IClassFactory	//// CUPS class factory
{
  protected:

  LONG	ref;				// Reference count

  public:

  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID FAR *obj);
  STDMETHOD_(ULONG,AddRef)(THIS);
  STDMETHOD_(ULONG,Release)(THIS);

  STDMETHOD(CreateInstance)(THIS_ LPUNKNOWN outer, REFIID riid,
                            LPVOID FAR *obj);
  STDMETHOD(LockServer)(THIS_ BOOL lock);

  cupsCF();
  ~cupsCF();
};


//
// Prototypes...
//

// Shared functions...
HRESULT		cupsDevMode(DWORD mode, POEMDMPARAM param);
extern "C" 
{
void		cupsDebug(int adjust, LPCWSTR format, ...);
STDAPI		DllCanUnloadNow();
STDAPI		DllGetClassObject(const CLSID &clsid, const IID &iid,
		                  void **data);
BOOL WINAPI	DllMain(HINSTANCE inst, WORD reason, LPVOID reserved);
}


#endif // !_COMMON_DRIVER_H_

//
// End of "$Id: driver.h,v 1.5 2005/06/17 20:54:20 mike Exp $".
//
